'================================================================================================
'
'   fmsg.bas
'
'       Interface module to fmsg.vbx
'
'================================================================================================
'Created By:
'
'   James Domino        jdomino@earthlink.net
'
'================================================================================================
'Update History:
'
'   date    by      Desc
'   ======  ======= =============================================================================
'
'================================================================================================
'Notes:
'
'   ???     Three question marks are used to highlight areas that may need further work.
'
'================================================================================================
'Options:

    Option Explicit
    Option Base 1

'================================================================================================
'Public Constants:
'================================================================================================
'Public Types:
'================================================================================================
'Public Vars:

    'A few dummy variables:
	Global voidI As Integer
	Global voidS As String
	Global voidL As Long

'================================================================================================
'Private Constants
'================================================================================================
'Private Types:
'================================================================================================
'Private Vars:
'================================================================================================
'Private External Functions Used:

    'Caller Functions:
	'Initiating a call
	    Declare Function fCallr Lib "fmsg.vbx" Alias "fmsgCallr" (fmsgctl As Control, frmName As String, Verb As String) As String
	    Declare Function fCall1r Lib "fmsg.vbx" Alias "fmsgCall1r" (fmsgctl As Control, frmName As String, Verb As String, In1 As String) As String
	    Declare Function fCall2r Lib "fmsg.vbx" Alias "fmsgCall2r" (fmsgctl As Control, frmName As String, Verb As String, In1 As String, In2 As String) As String
	    Declare Function fCall3r Lib "fmsg.vbx" Alias "fmsgCall3r" (fmsgctl As Control, frmName As String, Verb As String, In1 As String, In2 As String, In3 As String) As String
	    Declare Function fCall4r Lib "fmsg.vbx" Alias "fmsgCall4r" (fmsgctl As Control, frmName As String, Verb As String, In1 As String, In2 As String, In3 As String, In4 As String) As String
	    Declare Function fCall5r Lib "fmsg.vbx" Alias "fmsgCall5r" (fmsgctl As Control, frmName As String, Verb As String, In1 As String, In2 As String, In3 As String, In4 As String, In5 As String) As String
	    
	    Declare Sub fCall Lib "fmsg.vbx" Alias "fmsgCall" (fmsgctl As Control, frmName As String, Verb As String)
	    Declare Sub fCall1 Lib "fmsg.vbx" Alias "fmsgCall1" (fmsgctl As Control, frmName As String, Verb As String, In1 As String)
	    Declare Sub fCall2 Lib "fmsg.vbx" Alias "fmsgCall2" (fmsgctl As Control, frmName As String, Verb As String, In1 As String, In2 As String)
	    Declare Sub fCall3 Lib "fmsg.vbx" Alias "fmsgCall3" (fmsgctl As Control, frmName As String, Verb As String, In1 As String, In2 As String, In3 As String)
	    Declare Sub fCall4 Lib "fmsg.vbx" Alias "fmsgCall4" (fmsgctl As Control, frmName As String, Verb As String, In1 As String, In2 As String, In3 As String, In4 As String)
	    Declare Sub fCall5 Lib "fmsg.vbx" Alias "fmsgCall5" (fmsgctl As Control, frmName As String, Verb As String, In1 As String, In2 As String, In3 As String, In4 As String, In5 As String)
	
	'Retrieving return values
	    'these duplicate the function of the fmsg.vbx's properties called Out1 - Out5
	    'Ex:    if len(fmsg1.Out1)<>0 then ...
	    '          is equivalent to
	    '       if len(oOutGet1(fmsg1))<>0 then ...
	    Declare Function fOutGet1 Lib "fmsg.vbx" Alias "fmsgOutGet1" (fmsgctl As Control) As String
	    Declare Function fOutGet2 Lib "fmsg.vbx" Alias "fmsgOutGet2" (fmsgctl As Control) As String
	    Declare Function fOutGet3 Lib "fmsg.vbx" Alias "fmsgOutGet3" (fmsgctl As Control) As String
	    Declare Function fOutGet4 Lib "fmsg.vbx" Alias "fmsgOutGet4" (fmsgctl As Control) As String
	    Declare Function fOutGet5 Lib "fmsg.vbx" Alias "fmsgOutGet5" (fmsgctl As Control) As String
	    Declare Function fOutGetN Lib "fmsg.vbx" Alias "fmsgOutGetN" (fmsgctl As Control, ByVal OutNum As Integer) As String

	'Detecting and Getting errors:
	    Declare Sub fErrorClr Lib "fmsg.vbx" Alias "fmsgErrorClr" (fmsgctl As Control)
	    Declare Function fErrorWhoGet Lib "fmsg.vbx" Alias "fmsgErrorWhoGet" (fmsgctl As Control) As String
	    Declare Function fErrorParaGet Lib "fmsg.vbx" Alias "fmsgErrorParaGet" (fmsgctl As Control) As String
	    Declare Function fErrorTextGet Lib "fmsg.vbx" Alias "fmsgErrorTextGet" (fmsgctl As Control) As String
	    Declare Function fHasError Lib "fmsg.vbx" Alias "fmsgHasError" (ByVal hObj As Integer) As Integer
	    Declare Function fErrorCodeGet Lib "fmsg.vbx" Alias "fmsgErrorCodeGet" (ByVal hObj As Integer) As Integer

    'Callee Functions:

	'Retrieving input message verb
	    Declare Function fVerb Lib "fmsg.vbx" Alias "fmsgVerb" (ByVal hBuff As Integer) As String

	'Retrieving input message parameters
	    Declare Function fIn1 Lib "fmsg.vbx" Alias "fmsgIn1" (ByVal hBuff As Integer) As String
	    Declare Function fIn2 Lib "fmsg.vbx" Alias "fmsgIn2" (ByVal hBuff As Integer) As String
	    Declare Function fIn3 Lib "fmsg.vbx" Alias "fmsgIn3" (ByVal hBuff As Integer) As String
	    Declare Function fIn4 Lib "fmsg.vbx" Alias "fmsgIn4" (ByVal hBuff As Integer) As String
	    Declare Function fIn5 Lib "fmsg.vbx" Alias "fmsgIn5" (ByVal hBuff As Integer) As String
	    Declare Function fInN Lib "fmsg.vbx" Alias "fmsgInN" (ByVal hBuff As Integer, ByVal InNum As Integer) As String

	'Setting output return values
	    Declare Sub fOutSet1 Lib "fmsg.vbx" Alias "fmsgOutSet1" (ByVal hBuff As Integer, Out1 As String)
	    Declare Sub fOutSet2 Lib "fmsg.vbx" Alias "fmsgOutSet2" (ByVal hBuff As Integer, Out2 As String)
	    Declare Sub fOutSet3 Lib "fmsg.vbx" Alias "fmsgOutSet3" (ByVal hBuff As Integer, Out3 As String)
	    Declare Sub fOutSet4 Lib "fmsg.vbx" Alias "fmsgOutSet4" (ByVal hBuff As Integer, Out3 As String)
	    Declare Sub fOutSet5 Lib "fmsg.vbx" Alias "fmsgOutSet5" (ByVal hBuff As Integer, Out3 As String)
	    Declare Sub fOutSetN Lib "fmsg.vbx" Alias "fmsgOutSetN" (ByVal hBuff As Integer, OutN As String, ByVal OutNum As Integer)
    
	'Returning values:
	    Declare Sub fmsgRet1 Lib "fmsg.vbx" (ByVal hBuff As Integer, ret1 As String)
    
	'Setting Errors
	    Declare Sub fErrorSet Lib "fmsg.vbx" Alias "fmsgErrorSet" (ByVal hBuff As Integer, ByVal eeCode As Integer, eeWho As String, eeText As String, eePara As String)
    
    'Other functions:
	Declare Function fCloseAll Lib "fmsg.vbx" Alias "fmsgCloseAll" (fmsgctl As Control) As Integer
	
    'How To Registration functions
	Declare Function fHowtoRegister Lib "fmsg.vbx" Alias "fmsgHowtoRegister" (fmsgctl As Control, frmName As String, Verb As String, In1 As String, In2 As String) As Integer
    
    'Busy Functions:
	Declare Sub fBusySet Lib "fmsg.vbx" Alias "fmsgBusySet" (fmsgctl As Control, ByVal IsBusy As Integer)
	Declare Function fIsBusy Lib "fmsg.vbx" Alias "fmsgIsBusy" (fmsgctl As Control) As Integer
    
    'Event functions:
	Declare Function fEventFormKeyDown Lib "fmsg.vbx" Alias "fmsgEventFormKeyDown" (fmsgctl As Control, ByVal KeyCode As Integer, ByVal Shift As Integer) As Integer
	Declare Sub fEventActivate Lib "fmsg.vbx" Alias "fmsgEventActivate" (fmsgctl As Control)

    'Other Information Functions:
	Declare Function fIsValid Lib "fmsg.vbx" Alias "fmsgIsValid" (ByVal hObj As Integer) As Integer
	Declare Function fIsClient Lib "fmsg.vbx" Alias "fmsgIsClient" (ByVal hObj As Integer) As Integer
	Declare Function fCount Lib "fmsg.vbx" Alias "frmCount" () As Integer
	Declare Function frmNameGet Lib "fmsg.vbx" (ByVal hObj As Integer) As String
	Declare Function frmsMax Lib "fmsg.vbx" () As Integer

Function appPath () As String

    'returns the app's path

    If Right$(app.Path, 1) <> "\" Then
	appPath = app.Path & "\"
    Else
	appPath = app.Path
    End If

End Function

Sub fmsgErrCk (hBuff As Integer)

    'Checks for errors

    If Err Then
	fErrorSet hBuff, Err, "", Error$(Err) & " occurred while executing verb!", fVerb(hBuff)
	Err = 0
	'Debug.Print Error$(Err) & " occurred while executing verb! (" & fVerb(hBuff) & ")"
    End If

End Sub

Sub fmsgExecDefault (frm As Form, ctl As Control, hBuff As Integer)

    'handles default commands
    
    Dim tt As Integer
    Dim cc As Long

    On Error Resume Next
    Err = 0

    Select Case fVerb(hBuff)             'get first verb
	Case "CLOSE", "QUIT", "EXIT", "END", "DESTROY"
	    fRet1 hBuff, "0"
	    Unload frm
	    Exit Sub            'RRR

	Case "ID", "CREATE"             'return the obj's ID
	    fRet1 hBuff, ctl.hObj
	
	Case "ID.LOCK", "CREATE.LOCK"       'lock the object (make it busy), then return the ID
	    fBusySet ctl, True
	    fRet1 hBuff, ctl.hObj

	Case "BUSY.SET"
	    fBusySet ctl, Val(fIn1(hBuff))
	
	Case "BUSY.GET", "BUSY"
	    fRet1 hBuff, fIsBusy(ctl)

	Case "VISIBLE"
	    frm.Visible = (Not Val(fIn1(hBuff)) = 0)

	Case "HIDE"
	    frm.Hide
	
	Case "SHOW"
	    frm.Show
	
	Case "FOCUS"
	    frm.Show
	    '???TODO: this needs some adjustment???
	    'voidI = ctlFocusSetTab(frm, intVal(fIn1(hBuff)))     'sets focus on a given tabstop #
	
	Case "STATE"
	    frm.WindowState = Val(fIn1(hBuff))
	
	Case "STATE.MIN"
	    frm.WindowState = 1
	
	Case "STATE.MAX"
	    frm.WindowState = 2
	
	Case "STATE.NOR"
	    frm.WindowState = 0
	
	Case "CAPTION"
	    frm.Caption = fIn1(hBuff)
	
	Case "ZORDER"
	    frm.ZOrder Val(fIn1(hBuff))
	    
	Case "POS"
	    fRet1 hBuff, frm.Left & "," & frm.Top & "," & frm.Width & "," & frm.Height

	Case "POS.SET"
	    frm.Left = Val(strfldGet(fIn1(hBuff), ",", 1))
	    frm.Top = Val(strfldGet(fIn1(hBuff), ",", 2))
	    frm.Width = Val(strfldGet(fIn1(hBuff), ",", 3))
	    frm.Height = Val(strfldGet(fIn1(hBuff), ",", 4))

	Case "BACK.COLOR.SET"
	    cc = Val(fIn1(hBuff))
	    frm.BackColor = cc

	Case "FORE.COLOR.SET"
	    cc = Val(fIn1(hBuff))
	    frm.ForeColor = cc
	    
	Case "FONT.NAME.SET"
	    frm.FontName = fIn1(hBuff)
	
	Case "FONT.ATTRIB.SET"
	    cc = Val(fIn1(hBuff))
	    frm.FontBold = cc And 1
	    frm.FontItalic = cc And 2
	    frm.FontUnderline = cc And 4
	    frm.FontStrikethru = cc And 8
	
	Case "FONT.SIZE.SET"
	    frm.FontSize = fIn1(hBuff)
	
	Case "FONT.BOLD.SET"
	    frm.FontBold = Val(fIn1(hBuff))
	
	Case "FONT.ITALIC.SET"
	    frm.FontItalic = Val(fIn1(hBuff))
	
	Case "FONT.UNDERLINE.SET"
	    frm.FontUnderline = Val(fIn1(hBuff))
	
	Case "FONT.STRIKETHRU.SET"
	    frm.FontStrikethru = Val(fIn1(hBuff))
	
	Case Else
	    fErrorSet hBuff, 9, ctl.frmName & "(" & ctl.hObj & ")", "I don't know how to do this!", fVerb(hBuff)
	    
    End Select
    
    fmsgErrCk hBuff
    
End Sub

Sub fRet1 (hBuff As Integer, ByVal toRet As Variant)

    'returns a value

    fmsgRet1 hBuff, "" & toRet

End Sub

Function fVerbGet1 (hBuff As Integer) As String

    fVerbGet1 = strfldGet(fVerb(hBuff), ".", 1)

End Function

Function fVerbGet2 (hBuff As Integer) As String

    fVerbGet2 = strfldGet(fVerb(hBuff), ".", 2)

End Function

Function fVerbGet3 (hBuff As Integer) As String

    fVerbGet3 = strfldGet(fVerb(hBuff), ".", 3)

End Function

Function fVerbGetN (hBuff As Integer, numsubverb As Integer) As String

    fVerbGetN = strfldGet(fVerb(hBuff), ".", numsubverb)

End Function

Function intMin (inA As Integer, inB As Integer) As Integer

    'a simple function to return the smaller of the two numbers

    If inA < inB Then
	intMin = inA
    Else
	intMin = inB
    End If

End Function

Function strfldGet (strIn As String, del As String, fldnum As Integer) As String

    'gets a given field from a strfld

    'A new version of strfld that uses INSTR to speed the getting of strfld's

    Dim st As Integer
    Dim en As Integer

    If fldnum = 0 Then
	strfldGet = ""
	Exit Function
    End If

    st = strfldPos(strIn, del, fldnum)
    If st < 1 Then
	strfldGet = ""
    Else
	en = InStr(st, strIn, del)
	If en = 0 Then
	    en = Len(strIn) + Len(del) + 1
	Else
	    en = en + Len(del)
	End If
	strfldGet = Mid$(strIn, st, en - st - Len(del))
    End If

End Function

Function strfldPos (strIn As String, del As String, fldnum As Integer) As Integer

    'returns the position of the given field

    'RET:   ???TODO - add what happens if fldnum too low, or too high!

    Dim pp As Integer
    Dim cc As Integer

    pp = 1
    cc = 1

    While cc < fldnum            ' And pp <> 0
	pp = InStr(pp, strIn, del)
	If pp = 0 Then
	    cc = fldnum + 1
	Else
	    pp = pp + Len(del)
	    cc = cc + 1
	End If
    Wend

    strfldPos = pp

End Function

Function strfromfile (fname As String) As String

    'get the contents of a file into a string

    Dim ff As Integer
    Dim ss As String

    On Error Resume Next
    Err = 0

    ff = FreeFile
    Open fname For Binary As #ff

    If Err Then
	ss = ""
    Else
	ss = String$(intMin(gcStrMaxLen, LOF(ff)), 32)
	Get #ff, , ss
	Close #ff
    End If

    strfromfile = ss

End Function

Function strRepeat (numTimes As Integer, toRepeat As String) As String

    'function to repeat a given string numTimes

    'a slow, dumb way:

    Dim tt As Integer
    Dim oo As String

    For tt = 1 To numTimes
	oo = oo & toRepeat
    Next tt

    strRepeat = oo

End Function

Function strUT (strIn As String) As String

    'returns a uppercase, trim'd string

    strUT = UCase$(Trim$(strIn))

End Function

